/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */   

/*
 * Test Routines for SD cards on DM388 EVM.
 * 
 */

#include "dm388_EVM.h"
#include "dm388_types.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "sdmmc.h"

#define HSMMC_BASE1		0x481D8000
#define TEST_PATTERN	0xAB
#define MMCHS_SYSTEST	0x481D8128

INT32 SD_test(void *testargs)
{
	INT32 cardtype;
	INT32 is_highcap_card = 0;	
	INT32 retval = SUCCESS;
	INT32 sdmmc_rwtest (hsmmc_t *base, INT32 highcap_card);

	//SDMMCInit();
	platform_write("\n***********************\n\r");
	platform_write(  "         SD Test       \n\r");
	platform_write(  "***********************\n\r");
#ifdef PRINTF
	platform_write ("*) The test verifies the command, clock and data lines of sd/mmc by writing and verifies the data written\n");
#endif
	if(RD_MEM_32(MMCHS_SYSTEST)){
	platform_write ("\tCard not Detected\n");
	return -1;
	}
	else
	{
#ifdef PRINTF
	platform_write ("\tCard Detected\n");
#endif
	}
#ifdef PRINTF
	platform_write ("Running SDMMC Tests:\n");
#endif
	mmcinit((hsmmc_t *) HSMMC_BASE1);
	
	cardtype = detect_card((hsmmc_t *) HSMMC_BASE1, &is_highcap_card);
	switch (cardtype) {
	case MMC_CARD:
		platform_write ("\nMMC Card Detected\n");
		break;
	case SD_CARD:
		platform_write ("\nSD Card Detected\n");
		platform_write("\nRunning SD Card Read/Write Test\n");
		retval = sdmmc_rwtest((hsmmc_t *)HSMMC_BASE1, is_highcap_card);
		if (retval == SUCCESS)
		{
		platform_write("SD Card Read/Write Test Passed\n");
		}
		else
		{
		platform_write("SD Card Read/Write Test Failed\n");
		}
		break;
	case SDIO_CARD:
		retval = FAILURE;
		platform_write ("\nSDIO Card Detected\n");
		platform_write ("Please Insert an SDIO Card and run this program again!\n");
		break;
	case UNKNOWN_CARD:
	default:
		retval = FAILURE;
		platform_write ("\nUnable to communicate with the card\n");
		platform_write ("\nEnsure that an SD card is inserted into the Base Board of your EVM\n");
		break;
	}
	
	if (retval == SUCCESS)
	{
		platform_write ("\nSD Card Test Passed!\n");
		platform_write("\nSD Card Test Completed!!\n");
		platform_write("-----------x----------");
		return SUCCESS;
	}

	else
	{
		platform_write ("\nSD Card Test Failed\n");
		platform_write("-----------x----------");
		return FAILURE;
	}

}

INT32 sdmmc_rwtest (hsmmc_t *base, INT32 highcap_card)
{
	UINT8 writebuf[SECTOR_SIZE], readbuf[SECTOR_SIZE];
	UINT8 savebuf[SECTOR_SIZE];
	INT32 retval;
	INT32 block = 2;
	
	memset (writebuf, TEST_PATTERN, sizeof(writebuf));
	memset (readbuf, 0x00, sizeof(readbuf));
	
	retval = bread (base, highcap_card, block, SECTOR_SIZE, savebuf);
	if (retval < 0) {
		platform_write("Unable to Read Block data\n");
		return FAILURE;
	}

	platform_write("SDMMC: Writing a pattern to Block %d....", block);

	retval = bwrite (base, highcap_card, block, SECTOR_SIZE, writebuf);
	if (retval == SUCCESS)
		platform_write ("Write test passed\n");
	else {
		platform_write ("Unable to Write Sector\n");
		return FAILURE;
	}
	
	platform_write ("SDMMC: Reading from Block %d...", block);
	DM388_wait(1000);
	retval = bread (base, highcap_card, block, SECTOR_SIZE, readbuf);
	if (retval == SUCCESS)
		platform_write ("Read test passed\n");
	else {
		platform_write ("Unable to Read Sector\n");
		return FAILURE;
	}
	
	retval = bwrite (base, highcap_card, block, SECTOR_SIZE, savebuf);
	if (retval == FAILURE) {
		platform_write ("Unable to restore the original contents of the SDMMC card\n");
		return FAILURE;
	}
		
	if (memcmp(writebuf, readbuf, SECTOR_SIZE) == 0) {
		platform_write ("Verify data...Passed\n");
		return SUCCESS;
	} else {
		platform_write ("Verify data...Failed\n");
		return FAILURE;
	}
}
